/* Install.cmd */

call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
call SysLoadFuncs

/*
 *  Get the TeX environments and set the installation paths
 */
    env = VALUE('emtexdir',,'OS2ENVIRONMENT')
    env2 = Left( env, 2)

    Pfad.0 = 3
    if SysIni( "USER", "TeXEditor", "Pfad" ) \= 'ERROR:' then
	Pfad.1 = SysIni( "USER", "TeXEditor", "Pfad" )
    else
	Pfad.1 = env2||"\TeXEdit"
    Pfad.2 = env"\DLL"
    Pfad.3 = env||'\book'

/*
 *  Installation procedure
 */
    cls
    say '                            FSS - TeX Editor'
    say '                              Installation  '
    say
    say
    say 'Welcome to FSS-TexEdit.'
    say
    say 'During the installation procedure you have to enter some'
    say 'path informations. Please enter all paths without an ending'
    say 'backslash (\).'
    say

    say
    say 'Installation path for TeXEdit?'
    say '[Press ENTER for :'||Pfad.1||']'
    parse pull tmp
    if tmp \= '' then Pfad.1 = tmp
    ok = SysIni( "USER", "TeXEditor", "Pfad", Pfad.1 )

    say
    say 'Installation path for the DLL files?'
    say '[Press ENTER for :'||Pfad.2||']'
    parse pull tmp
    if tmp \= '' then Pfad.2 = tmp

    say
    say 'Installation path for the INF files?'
    say '[Press ENTER for :'||Pfad.3||']'
    parse pull tmp
    if tmp \= '' then Pfad.3 = tmp

    do i = 1 to Pfad.0
	call SysFileTree Pfad.i, 'tmp', 'D'
    if tmp.0 = 0 then do
	    ok = SysMkDir(Pfad.i)
	    if ok \= 0 then do
		say 'ERROR: Directory '||Pfad.i||'could not be created.'
		exit
	    end
	end
    end

    Datei.0 = 6
    Datei.1 = '*.exe'
    Datei.2 = '*.txt'
    Datei.3 = '*.cmd'
    Datei.4 = '*.ico'
    Datei.5 = '*.bmp'
    Datei.6 = '*.cmd'

    do i = 1 to Datei.0
	'@copy '||Datei.i||' '||Pfad.1
    end

    '@copy *.dll '||Pfad.2
    '@copy *.inf '||Pfad.3


/*
 *  Create the objects on the desktop
 */
    say
    say 'Please choose a startup directory for TeXEdit? [ENTER for none]'
    parse pull StartUpDir

    object.0 = 4
    object.1 = 'EXENAME='||Pfad.1||'\TeXEdit.exe;STARTUPDIR='||StartUpDir
    object.2 = 'EXENAME='||Pfad.1||'\TeXEdit.exe;STARTUPDIR='||StartUpDir||';PARAMETERS=-p'
    object.3 = 'EXENAME=View.exe;PARAMETERS=TeXEdit.INF'
    object.4 = 'EXENAME=e.exe;PARAMETERS='||Pfad.1||'\New.txt'

    caption.1 = 'TeXEditor'
    caption.2 = 'PreLoad'
    caption.3 = 'Help'
    caption.4 = 'New'


    if SysCreateObject("WPFolder", "FSS-TeXEditor", "<WP_DESKTOP>",,
	"OBJECTID=<MEINORDNER>") Then nop
    do i = 1 to object.0
	If SysCreateObject("WPProgram", caption.i, "<MEINORDNER>",,
	    object.i)  Then a = 1
    end
    If SysCreateObject("WPProgram", "TeXEditor", "<MEINORDNER>",,
	'ASSOCFILTER=*.TEX,*.TEV', "update" )  Then a = 1

    say
    say 'The following environment have to be add to your CONFIG.SYS:'
    say '   '||Pfad.1||' will be added to <path>.'
    say '   '||Pfad.2||' will be added to <libpath>.'
    say '   '||Pfad.3||' will be added to <bookshelf>.'
    say 'Should the installation programm add these environments? [y|n]'
    pull char
    if char = 'N' then exit

/*
 *  Modify the CONFIG.SYS
 */
    env = VALUE('USER_INI',,'OS2ENVIRONMENT')
    env = Left( env, 2)

    search.0 = 3
    search.1 = 'SET PATH'
    search.3 = 'SET BOOKSHELF'
    search.2 = 'LIBPATH'

    do while lines( env||'\config.sys') > 0
	line = LineIn( env||'\config.sys')
	tmp = TRANSLATE( line)
	do i = 1 to search.0
	    if pos( search.i, tmp) > 0 then do
		pos = Pos( TRANSLATE( Pfad.i)||';', tmp)
		if pos = 0 then do
		    do while (Right( tmp, 1) = ' ') | (Right( tmp, 1) = ';')
			l = length(tmp)
			tmp = SubStr(tmp, 1, l - 1)
			line = SubStr(line, 1, l - 1)
		    end
		    line = line||';'||Pfad.i||';'
		end
	    end
	end
	call LineOut env||'\config.new', line
    end
    call LineOut env||'\config.sys'
    call LineOut env||'\config.new'

    '@copy '||env||'\config.sys '||env||'\config.old'
    '@copy '||env||'\config.new '||env||'\config.sys'
    '@del '||env||'\config.new'

    cls
    say
    say 'Your CONFIG.SYS was saved as CONFIG.OLD.'
    say
    say 'Please reboot your computer to make the new environment valid.'

/* End of Install.cmd */
