/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

#ifndef NO_ASM
#pragma inline
#endif

#include <stdlib.h>
#include <assert.h>
#include "window.h"
#include "bitmap\arrow.c"
#include "bitmap\wait.c"

#define MOUSE_INTR 0x33

int x_min, y_min, x_max, y_max;

/* ----- Mouse interface. ------------------------------------------- */

void set_mouse_speed(int speed)
{
  asm {
    mov ax, 0x1a
    mov bx, speed       /* horizontal */
    mov cx, bx
    shl cx, 1           /* vertical */
    mov dx, 0           /* double speed threshhold */
    int MOUSE_INTR
  }
}

int get_mouse_speed(void)
{
  asm {
    mov ax, 0x1b
    int MOUSE_INTR
  }
  return _BX;
}

LOCAL(void) warp_mouse(int x, int y)
{
  asm {
    mov ax, 4
    mov cx, x
    mov dx, y
    int MOUSE_INTR
  }
}

void get_mouse_status(int *x, int *y, unsigned *mask)
{
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
  asm {
    mov ax, 3
    int MOUSE_INTR
    mov di, mask
    mov [di], bx
    mov di, x
    mov [di], cx
    mov di, y
    mov [di], dx
  }
#else
  asm {
    mov ax, 3
    int MOUSE_INTR
    les di, mask
    mov es:[di], bx
    les di, x
    mov es:[di], cx
    les di, y
    mov es:[di], dx
  }
#endif
}

static int waiting_p = 0;

void set_wait_cursor(int p)
{
  if (p && !waiting_p) {
    set_mouse_cursor((unsigned far *)wait_bits, wait_hot_x, wait_hot_y);
    push_mouse_cursor_state(1);
  }
  else if (!p && waiting_p) {
    pop_mouse_cursor_state();
    set_mouse_cursor(0, 0, 0);
  }
  waiting_p = p;
}

void set_mouse_cursor(unsigned far *bits, int hot_x, int hot_y)
{
  if (bits == NULL) {
    bits = (unsigned far *)arrow_bits;
    hot_x = arrow_hot_x;
    hot_y = arrow_hot_y;
  }
  asm {
    mov ax, 9
    mov bx, hot_x
    mov cx, hot_y
    les dx, bits
    int MOUSE_INTR
  }
}

static int on_p = 0;

void protect_mouse_cursor(int x0, int y0, int x1, int y1)
{
  if (on_p) asm {
    mov ax, 16
    mov cx, x0
    mov dx, y0
    mov si, x1
    mov di, y1
    int MOUSE_INTR
  }
}

void unprotect_mouse_cursor(void)
{
  if (on_p) asm {
    mov ax, 1
    int MOUSE_INTR
  }
}

void show_mouse_cursor(int p)
{
  if ((p = !!p) != on_p) {
    asm {
      mov ax, 2
      sub ax, p
      int MOUSE_INTR
    }
    on_p = p;
  }
}

#define MAX_STATES 8
static int cursor_state[MAX_STATES], csp = 0;

void push_mouse_cursor_state(int p)
{
  assert(csp < MAX_STATES);
  cursor_state[csp++] = on_p;
  show_mouse_cursor(p);
}

void pop_mouse_cursor_state(void)
{
  assert(csp > 0);
  show_mouse_cursor(cursor_state[--csp]);
}

int set_mouse_arena(int x0, int y0, int x1, int y1)
{
  asm {
    xor ax, ax
    int MOUSE_INTR
  }
  if (_AX != 0xffff)
    return 0;
  set_mouse_cursor(0,0,0);
  asm {
    mov ax, 7
    mov cx, x0
    mov dx, x1
    int MOUSE_INTR
    mov ax, 8
    mov cx, y0
    mov dx, y1
    int MOUSE_INTR
  }
  warp_mouse((x0 + x1)/2, (y0 + y1)/2);
  x_min = x0;
  y_min = y0;
  x_max = x1;
  y_max = y1;
  return(1);
}
