#!/bin/sh
#-*-tcl-*-
# the next line restarts using wish \
exec wish "$0" ${1+"$@"}

if {$tcl_platform(os) == "MacOS"} {
    catch {package require MacOSdefaults}
} else {
    #wm overrideredirect . 1
    proc echo {txt} {
	puts stdout $txt
    }
}

wm withdraw .

if {[info tclversion] < 8.0} {
    error "Sorry, we require Tcl version 8.0 or newer"
    return
}
if {[info tclversion] < 8.1} {
    echo "Tcl 8.0 still has rather limited regexps.  I'll use the nre package"
    echo "if you have it available, but you're best off upgrading to Tcl 8.1."
    echo "Otherwise Alpha can't be as sophisticated as it would like about"
    echo "word boundaries and things like that."
    catch {
	package require nre 3.0
	nreuse 1
    }
} 

if {[catch {package require msgcat}]} {
    echo "The msgcat package is required if you want to use a localised version of Alpha"
    namespace eval msgcat {}
    proc msgcat::mc {str} { return $str }
    proc msgcat::mclocale {args} {}
    proc msgcat::mcunknown {locale string} { return $string }
} else {
    msgcat::mcload Localisation
    # auto_load
    catch {msgcat::mcunknown blah blah}
}

if {[catch {package require Tclx}]} {
    echo "Installing Tclx speeds up some operations inside Alpha"
}
if {[catch {package require FTP}]} {
    echo "Install the FTP package to let Alpha update itself more simply;"
    echo "download from: http://home.t-online.de/home/Steffen.Traeger/tindexe.htm"
} else {
    namespace eval FTP {
    proc DisplayMsg {msg {state ""}} {
	switch -- $state {
	  data	{::message $msg}
	  control	{::message $msg}
	  error	{::message $msg}
	}	
    }}
}
if {[catch {glob -nocomplain -dir a *}]} {
    echo "Suggestion: if you patch Tcl with my 'glob' patch, Alpha will run more quickly."
}


namespace eval alpha {
    namespace eval index {}
    namespace eval cache {}
    set haveBasicKeys 1
    proc checkFileExists {dir {isdir 0}} {
	if {![file exists $dir] || \
	  ($isdir && ![file isdir $dir]) || (!$isdir && ![file isfile $dir])} {
	    tk_messageBox -title "Fatal AlphaTk error" -message \
	      "AlphaTk cannot find its\
	      [expr {$isdir ? {directory} : {file}}]\
	      '[file join [pwd] $dir]'.\
	      You should reinstall AlphaTk.  Goodbye."
	    exit
	}
    }
}
if {[info commands quit] == ""} {
    rename exit quit
    proc exit {} {}
}

switch -- $tcl_platform(platform) {
    "unix" {
	# we have send
    }
    "windows" {
	# On windows we're supposed to use the 'dde' package instead of send.
	proc send {args} {
	    echo "No send! Ignored $args"
	}
	if {[catch {package require dde}]} {
	    echo "Problems loading dde package.  Interaction with other"
	    echo "windows applications will be much impaired."
	} else {
	    dde servername Alpha
	    update idletasks
	    echo "Creating dde server for [dde services TclEval {}]"
	}
    }
    "macintosh" {
	if {[catch {
	    package require Comm 3
	    # let's hope this isn't used!
	    comm config -port 1197 -local 1 -listen 1
	}]} {
	    echo "Problems loading Comm package or port already in use."
	    echo "Won't be able to use remote invocation."
	}
    }
    default {
	error "No known platform"
    }
}

image create photo lock -file [file join Alpha lock.gif]
image create photo dirty -file [file join Alpha dirty.gif]
image create photo clean -file [file join Alpha clean.gif]

alpha::checkFileExists [file join Alpha Tcl] 1

# Do this stuff to deal with aliases/links for easily later on.
# We want 'HOME' to point to the parent of 'Tcl'.
if {[info exists tcl_platform(isWrapped)]} {
    set from [file join Alpha Tcl]
} else {
    set from [file join [pwd] Alpha Tcl]
}
if {[catch {file readlink $from} HOME]} {
    set HOME $from
}
unset from

set HOME [file dirname $HOME]


alpha::checkFileExists [file join $HOME AlphaCore] 1

# Load in either byte-compiled or source scripts.
foreach f {alpha_menus alpha_commands alpha_dialogs \
  alpha_startup alpha_procs alpha_windows alpha_vars alpha_search \
  alpha_editing alpha_register balloonHelp} {
    if {[file exists [file join $HOME AlphaCore ${f}.tbc]]} {
	source [file join $HOME AlphaCore ${f}.tbc]
    } else {
	source [file join $HOME AlphaCore ${f}.tcl]
    }
}
unset f

proc alpha::setIcon {w} {}
set alpha::useMyIcons 0
switch -- $tcl_platform(platform) {
    "windows" {
	set alpha::modifier_keys [list "Alt" "alt" "Meta" "meta"]
	set alpha::command_key "Alt"
	set alpha::option_key "Meta"
	if {![catch {package require Winico}]} {
	    source [file join $HOME AlphaCore alpha_win_ico.tcl]
	    set alpha::useMyIcons 1
	    set alpha::icon [alpha::loadIcon alpha.icr]
	    #proc taskbar_cmd { message ico wparam lparam x y } {
	    #  puts stderr "taskbar_cmd with $message,ico:$ico,wParam:$wparam,lParam:$lparam,x:$x,y:$y"
	    #}
	    #winico text $alpha::icon "This is a taskbar sample text"
	    #winico taskbar add $alpha::icon -callback "taskbar_cmd %m %i %w %l %x %y"
	    #after 20000 "winico delete $ico"
	    proc alpha::setIcon {w} {
		variable icon
		variable bigIcon
		variable smallIcon
		winico setwindow $w $icon big   $bigIcon
		winico setwindow $w $icon small $smallIcon
	    }
	    alpha::setIcon .
	} else {
	    echo "Suggestion: install the 'Winico' package to let Alpha use nice icons for its windows."
	}
	
	if {![catch {package require printer}] && ![catch {package require gdi}]} {
	    source [file join $HOME AlphaCore alpha_win_print.tcl]
	} else {
	    echo "Printing under windows requires the 'printer' and 'gdi' extensions."
	}
	# macos specific
	proc resource {args} { echo "Called MacOS only: resource $args" }
    }
    "macintosh" {
	set alpha::modifier_keys [list "Command" "cmd" "Option" "opt"]
	set alpha::command_key "Command"
	set alpha::option_key "Option"
    }
    "unix" -
    default {
	set alpha::modifier_keys [list "Alt" "alt" "Meta" "meta"]
	set alpha::command_key "Alt"
	set alpha::option_key "Meta"
	# macos specific
	proc resource {args} { echo "Called MacOS only: resource $args" }
    }
}

set alpha::platform tk

alpha::checkFileExists [file join $HOME Tcl SystemCode] 1

namespace eval pos {}
proc pos::compare {args} {
    eval text_cmd compare $args
}
proc pos::math {i args} { 
    if {[llength $args] < 2} {
	return [text_cmd index "$i [join $args ""]c"]
    } else {
	return [text_cmd index "$i +[eval expr $args]c"]
    }
}

namespace eval global {}

alpha::checkFileExists [file join $HOME Tcl SystemCode AlphaBits.tcl]

source [file join $HOME Tcl SystemCode AlphaBits.tcl]
wm deiconify .

if {$tcl_platform(platform) != "unix"} {
    menu::insert File items end showTkConsole
    proc showTkConsole {} {
	console show
	console eval {raise .}
    }
}

menuEnableHook [expr {[win::Current] != ""}]

# if we're called up with more arguments, evaluate them.
# Normally they'll be items of the form "edit <file>"
if {$argc>0} {
    foreach str $argv {
	eval $str
    }
}

auto_load bgerror
set alpha_error ""
rename bgerror tk_bgerror
proc bgerror {err} {
    global alpha_error
    message $err
    set alpha_error $err
}

proc alpha_stackdump {} {
    global alpha_error
    tk_bgerror $alpha_error
}

alpha::checkRegistration



