## -*-Tcl-*-
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "testing.tcl"
 #                                    created: 30/7/97 {7:37:34 pm} 
 #                                last update: 31/1/1999 {2:38:27 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # This file contains procs which are useful for testing a few
 # things... but not useful for a general alpha distribution.
 # ###################################################################
 ##

alpha::extension Testing 0.1

## 
 # addHelpMenu 
 # alloced - some memory information
 # alphaCreateTagFile 
 # alphaFindTag	
 # backwardWordSelect 
 # beep	- standard Tcl
 # bindingList - dumps all current bindings	into the window
 # closeFloat 
 # coerce 
 # copyFile	- copies a file
 # cvttime 
 # dumpDebug 
 # enterReplaceString -	makes selected string the replace string, but wrong	message.
 # enterSearchString - makes the selected string the search	string,	and	message.
 # fileMenu	
 # floatIcon 
 # forwardWordSelect 
 # gotoLine	- brings up	the	goto-line dialog
 # gotoNamedMark - brings up a goto mark dialog
 # init	- 
 # keyboardMacro 
 # kt - keytest?? echo next keypress?
 # linkVar - used to link internal Alpha variable with Tcl flag
 # ls -	directory listing
 # modified	
 # now - gets time in seconds
 # postHigh	
 # printRegistration - gets	name and email address and prints 
 # removeColorEscapes -	removes	all	colour/hyper codes from	a window
 # removeNamedMark - 
 # replaceAllOld 
 # saveAll - saves all windows
 # setCompiler 
 # setRGB - see colorProc for an example
 # status 
 # subst - standard	Tcl
 # ticks - number ticks	(100'ths of	a second?) since something
 # toolserverShell - open toolserver shell window
 # traceDump 
 # winFuncTitle
 # wins	- gets dimensions of all windows
 # wrapText	- wraps	body of	text from pos1 to pos2
 ##

proc findUnlistedCmds {} {
    global HOME
    foreach text [info commands] {
	if {[string length [procs::find $text]]} {
	    continue
	}
	if {[string length [grep "^ $text " "$HOME:Help:Alpha Commands"]]} {
	    continue
	}
	if {[string length [grep "^     $text -" "$HOME:Help:Tcl Commands"]]} {
	    continue
	}
	lappend nodocs $text
    }
    return $nodocs
}

	
proc procs::findUsageFrequency {dir} {
    global HOME
    source "$HOME:Tcl:${dir}:tclIndexx"
    set a [set ${dir}_index]
    foreach f $a {
	if {[llength $f] > 1} {eval lappend procs [lrange $f 1 end]}
    }
    set l [llength $procs]
    foreach p $procs {
	set reg "^.*\\b${p}\\b.*$"
	set cid [scancontext create]
	set count($p) 0
	message "$p, $l left"
	scanmatch $cid $reg "incr count($p)"
	foreach f [glob -nocomplain ${HOME}:Tcl:${dir}:*.tcl] {
	    if {![catch {set fid [open $f]}]} {
		message [file tail $f]
		scanfile $cid $fid
		close $fid
	    }
	}
	scancontext delete $cid
	incr l -1
    }
    new -n "* proc count *"
    insertText -w "* proc count *" [array get count]
}

proc procs::rememberChanged {p} {
    global __changedProcs
    lappend __changedProcs $p
}

proc procs::updateAllChanged {} {
    global __changedProcs
    foreach p $__changedProcs {
	if {[catch {procs::replace $p 0}]} {
	    lappend failed $p
	}
    }
    if {[info exists failed]} {
	alertnote "Couldn't find: $failed"
    }
    alertnote "Replaced [llength $__changedProcs] procs successfully."
}

