#############################################################################
# AppleScript.tcl
#  John Sarapata
#  sarapata_john@jpmorgan.com
#
# Description:
#	This file implements an AppleScript mode, for people who wish Script
#	Editor had complex functions like search and replace. Currently, it
#	only supports color editing and function finding, but I may extend it.
#
#	I have not found a way to distinguish function definitions from
#	on error constructs, so I assume that any "on name" statements at
#	the beginning of the line are definitions. Script Editor saves files
#	in this format, so you will only need to be careful when creating
#	functions in Alpha.
#############################################################################

alpha::mode Scrp 1.0.1 dummyScrp {*.script} {electricBraces electricTab}

#===============================================================================
#	Set up the mode variables
newPref	v wordWrap {0} Scrp
newPref	f autoMark {0} Scrp
newPref	v prefixString {--} Scrp
newPref	v leftFillColumn {3} Scrp
newPref	v funcExpr {^(on)[ \t]+(\w+)} Scrp
newPref	v parseExpr {^[^ \t]+[ \t]+(\w+)} Scrp
newPref	v wordBreak {\w+} Scrp
newPref	v wordBreakPreface {\W} Scrp

proc dummyScrp {} {}

#===============================================================================
#	Set up comments and keywords
set scriptKeyWords {
    on end error global local return it me pi result space tab close copy 
    count data size delete duplicate exists get launch make move open print 
    quit run save in of is after before div mod and not or start starts 
    begin begins end ends contains does equal equals greater less than as 
    reference set try tell if repeat else then times while until with by 
    considering ignoring timeout transaction script property prop first 
    second third fourth fifth sixth seventh eighth ninth tenth last front 
    back middle every some from to through thru
}

regModeKeywords -e {--} -b {\(*} {*\)} -c red -k blue Scrp $scriptKeyWords

unset scriptKeyWords

#===============================================================================
#	File Marking
proc Scrp::MarkFile {} {
    global ScrpmodeVars
    set pos [minPos]
    while {![catch {search -s -f 1 -r 1 -m 0 -i 1 $ScrpmodeVars(funcExpr) $pos} res]} {
	set start [lindex $res 0]
	set end [lindex $res 1]
	set text [lindex [split [getText $start $end]] 1]
	set pos $end
	set inds($text) $res
    }
    
    if {[info exists inds]} {
	foreach f [lsort [array names inds]] {
	    setNamedMark $f [lineStart [pos::math [lineStart [lindex $inds($f) 0]] - 1]] \
	      [lindex $inds($f) 0] [lindex $inds($f) 1]
	}
    }
}

